using Microsoft.VisualBasic;
using System;
using System.Data;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class StudiosBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the StudiosBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public StudiosBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the StudiosBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public StudiosBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the StudiosBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected StudiosBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the StudiosBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(StudiosBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(StudiosBO_SetDefaultValues);
		}
		
		#endregion
		
		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void StudiosBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void StudiosBO_SetDefaultValues()
		{
			
		}
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Retrieves the studio name
		/// </summary>
		/// <param name="studioPk"></param>
		/// <returns></returns>
		/// <remarks></remarks>
		public static string GetStudioName(long studioPk)
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT st_Name FROM Studios WHERE st_pk = @studioPk");
			object r;
			
			//-- Set the parms
			cmd.Parameters.AddWithValue("@studioPk", studioPk).SqlDbType = SqlDbType.BigInt;
			
			//-- Get the value
			using (StudiosBO bo = new StudiosBO())
			{
				r = bo.ExecuteScalar(cmd);
				
				if (r == null || r == DBNull.Value)
				{
					return "";
				}
				else
				{
					return System.Convert.ToString(r);
				}
			}
			
		}
		
		/// <summary>
		/// Populates the BO with all records with the PK and title only
		/// </summary>
		/// <remarks></remarks>
		public void FillAllForCombo()
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT st_pk, st_Name FROM Studios ORDER BY st_Name");
			
			//-- Execute the query
			this.FillDataTable(cmd);
		}
		
		#endregion
		
	}
	
}
